/*-------------------------------------------------------*
*  Name:      DAT Filter for ZModeler v1.06              *
*  Purpose:   Test Drive 6 import filter                 *
*  Authors:                                              *
*  History:   16.Sep.2001 - rebuild for ZModeler v1.06   *
*                                                        *
*-------------------------------------------------------*/
#include <Struct.h>
#include <3DEngine.h>

#include "DAT.h"
const float DATGeometryCoef = 300.0f;

//////////////////////////////////////////////////////////////
//  DWORD Capabilities - a combination versions
DWORD CALLBACK Capabilities(long)
{
  return ZMODELER_BUILD_VERSION();
}

//////////////////////////////////////////////////////////////
//  DWORD Supports returns a combination of supported features
DWORD CALLBACK Supports(DWORD)
{
  return Z3D_PLUGSUPPORTS_IMPORT /*| Z3D_PLUGSUPPORTS_EXPORT*/;
}

//////////////////////////////////////////////////////////////
//  DWORD DynamicLoading specifies whether the dll will be
//  loaded only when it'sfunctions are needed.
//  You should NOT make it dynamic, if it is a processor-type.
DWORD CALLBACK DynamicLoading(DWORD)
{
  return 1L; // DLL will be loaded each time it is needed
}

//////////////////////////////////////////////////////////////
//  void GetFilterExtension returns a file extention for sup-
//  ported files. Used if it is an IMPORT/EXPORT type
char* CALLBACK GetFilterExtension(DWORD)
{
  return "dat";
}

//////////////////////////////////////////////////////////////
//  void GetFilterMask returns a file-mask for CFileDilaog.
//  Used if it is an IMPORT/EXPORT type.
char* CALLBACK GetFilterMask(DWORD)
{
  return "Test Drive 6 (*.dat)|*.dat|";
}



//////////////////////////////////////////////////////////////
//  Shows a failure message.
DWORD _stdcall ShowFailMessage(CWnd* pwnd, char *errmsg, char *cause, UINT icon)
{
  char str[512];
  strcpy(str, "Error importing/exporting file: ");
  strcat(str, errmsg);
  strcat(str, "\nPossible caused by: ");
  strcat(str, cause);
  pwnd->MessageBox(str,"Filter message:", icon);
  return 0;
}






/**********************************************************************/
//    
/**********************************************************************/
DWORD CALLBACK Import(  CString fromfile,
                CWnd *pwnd,
                tObjectSet* Objects,
                tUnDataSet* UnData,
                CDirect3D*  d3d,
                SYSTEMREQUESTPROC RequestProc,
                HINSTANCE AppHIns,
                HINSTANCE DllHIns)
{
  CFile InFile;

  if (!InFile.Open(fromfile, CFile::modeRead))
    return ShowFailMessage(pwnd, "can not open the specified file.", "invalid file attributes or share violation.", MB_ICONHAND);

  tDATHeader  Header;
  tDATVert*   pVerts;
  short*      pFaces;
  int         i, mat;
  CString    filename = fromfile.Right(fromfile.GetLength()-fromfile.ReverseFind('\\')-1);
  filename = filename.Left(filename.Find('.'));

  InFile.Read(&Header, sizeof(tDATHeader));
  
  pVerts = new tDATVert[Header.NumVertices];
  pFaces = new short[Header.NumFaceIndexes];

  InFile.ReadHuge(pFaces, 2*Header.NumFaceIndexes);
  InFile.Seek(Header.VertsOffset, CFile::begin);
  InFile.ReadHuge(pVerts, sizeof(tDATVert)*Header.NumVertices);
  InFile.Close();

  mat = d3d->CreateMaterial(
      1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 80.0f,
      "carbody.tga",
      NULL,
      "chrome.bmp",
      NULL,
      filename.GetBuffer(MAX_MATERIALNAMELEN),
      TEX_NAMEPATHMATCH_NOCASE | TEX_NAMEPATHMATCH_NAMEONLY,
      D3DTOP_MODULATE,
      D3DTOP_DISABLE,
      D3DTOP_ADD,
      D3DTOP_DISABLE,
      D3DBLEND_SRCALPHA,
      D3DBLEND_INVSRCALPHA,
      1);
  tObject* pObj = new tObject(filename.GetBuffer(32), Header.NumVertices, Header.NumFaceIndexes/3);

  for (i = 0; i < Header.NumVertices; i++)
  {
    pObj->VertTable->Table[i].X = pVerts[i].x / DATGeometryCoef;
    pObj->VertTable->Table[i].Y = pVerts[i].y / DATGeometryCoef;
    pObj->VertTable->Table[i].Z = pVerts[i].z / DATGeometryCoef;
    pObj->VertTable->Table[i].NormalX = pVerts[i].nx;
    pObj->VertTable->Table[i].NormalY = pVerts[i].ny;
    pObj->VertTable->Table[i].NormalZ = pVerts[i].nz;
  }


  for (i = 0; i < pObj->FaceTable->FaceAmount; i++)
  {
    pObj->FaceTable->Table[i].I1 = pFaces[i*3];
    pObj->FaceTable->Table[i].I2 = pFaces[i*3+1];
    pObj->FaceTable->Table[i].I3 = pFaces[i*3+2];
    pObj->FaceTable->Table[i].U1 = pVerts[pObj->FaceTable->Table[i].I1].u;
    pObj->FaceTable->Table[i].V1 = 1.0f-pVerts[pObj->FaceTable->Table[i].I1].v;
    pObj->FaceTable->Table[i].U2 = pVerts[pObj->FaceTable->Table[i].I2].u;
    pObj->FaceTable->Table[i].V2 = 1.0f-pVerts[pObj->FaceTable->Table[i].I2].v;
    pObj->FaceTable->Table[i].U3 = pVerts[pObj->FaceTable->Table[i].I3].u;
    pObj->FaceTable->Table[i].V3 = 1.0f-pVerts[pObj->FaceTable->Table[i].I3].v;
    pObj->FaceTable->Table[i].Material = mat;
  }

  Objects->AddObject(pObj);
  delete pObj;

  delete[] pVerts;
  delete[] pFaces;

  return Z3D_PLUGRESULT_REDRAW;
}//Import





